import logging
from cse_image_items.ManifestExtension import ClientSystemInfoExtensionExtension
from utils import bytes_to_int


logger = logging.getLogger(__name__)

class MetaData(object):
    def __init__(self, cse_region):
        logger.info('START Image.__init__ FUNCTION')
        bup_manifest = self.get_BUPManifest(cse_region)
        if bup_manifest == None:
            logger.exception('bup_manifest is not exist')
            raise AttributeError('bup_manifest is not exist')
        self.FW_version = self.get_FW_version(bup_manifest)
        client_system_info_extension = self.get_client_system_info_extension(bup_manifest)
        if client_system_info_extension == None:
            logger.exception('client_system_info_extension is not exist')
            raise AttributeError('client_system_info_extension is not exist')
        self.FW_sku_type = self.get_FW_sku_type(client_system_info_extension)
        # known issue, to be fixed
        self.pch_type = self.get_pch_type(client_system_info_extension)
        logger.info('IMAGE METADATA: FWVersion [%s], FWSkuType [%s], pchType [%s]' %(self.FW_version, self.FW_sku_type, self.pch_type))

    def get_BUPManifest(self, cse_region):
        for bpdt in cse_region.logical_boot_partitions:
            for sub_partition_directory_entry in bpdt.sub_partition_directory_entries:
                if sub_partition_directory_entry.entry_type == u'CSE_BUP':
                    for entry in sub_partition_directory_entry.entries:
                        if entry.is_manifest:
                            return entry.manifest

    def get_client_system_info_extension(self, bup_manifest):
        for extention in bup_manifest.extentions:
            if isinstance(extention, ClientSystemInfoExtensionExtension):
                return extention

    def get_FW_version(self, bup_manifest):
            bin_version = bup_manifest.header.version.bytes_value()
            major = bytes_to_int(bup_manifest.header.version.bytes_value()[:2])
            minor = bytes_to_int(bup_manifest.header.version.bytes_value()[2:4])
            hotfix = bytes_to_int(bup_manifest.header.version.bytes_value()[4:6]) 
            build = bytes_to_int(bup_manifest.header.version.bytes_value()[6:])
            return '%s.%s.%s.%s'%(major, minor, hotfix, build)

    def get_FW_sku_type(self, client_system_info_extension):
        return client_system_info_extension.sku_type

    def get_pch_type(self, client_system_info_extension):
        return client_system_info_extension.pch_type



